#include <algorithm>
#include <cmath>
#include <iostream>
#include <vector>

using namespace std;

struct Move {
    int id;
    long long x;
    long long y;
    long double angle;
};

bool compare(const Move &a, const Move &b) {
    bool upperA = (a.y > 0 || (a.y == 0 && a.x < 0)), upperB = (b.y > 0 || (b.y == 0 && b.x < 0));
    if (upperA != upperB) return !upperA && upperB;
    __int128 cp = (__int128)a.x * b.y - (__int128)a.y * b.x;
    if (cp != 0) return cp > 0;
    return (__int128)a.x * a.x + (__int128)a.y * a.y < (__int128)b.x * b.x + (__int128)b.y * b.y;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    int n;
    cin >> n;
    vector<Move> moves(n);

    for (int i = 0; i < n; i++) {
        Move m;
        m.id = i + 1;
        cin >> m.x >> m.y;
        m.angle = atan2l((long double)m.y, (long double)m.x);
        moves[i] = m;
    }

    sort(moves.begin(), moves.end(), compare);
    moves.reserve(2 * n);
    for (int i = 0; i < n; i++) {
        moves.push_back(moves[i]);
    }

    int left = 0, l = 0, r = -1;
    __int128 x = 0, y = 0, maxDist = -1;
    for (int right = 0; right < 2 * n; right++) {
        x += moves[right].x;
        y += moves[right].y;

        while (left < right) {
            if (right - left >= n) {
                x -= moves[left].x;
                y -= moves[left].y;
                left++;
                continue;
            }

            __int128 cp = (__int128)moves[left].x * moves[right].y - (__int128)moves[left].y * moves[right].x;
            __int128 dp = (__int128)moves[left].x * moves[right].x + (__int128)moves[left].y * moves[right].y;
            if (cp < 0 || (cp == 0 && dp < 0)) {
                x -= moves[left].x;
                y -= moves[left].y;
                left++;
            } else {
                break;
            }
        }

        __int128 dist = x * x + y * y;
        if (dist > maxDist) {
            maxDist = dist;
            l = left;
            r = right;
        }
    }

    cout << r - l + 1 << endl;
    for (int i = l; i < r; i++) {
        cout << moves[i].id << " ";
    }

    cout << moves[r].id << endl;
    return 0;
}